IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_EST_ARV_MERCADOLOGICA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_EST_ARV_MERCADOLOGICA]
GO 

SET ANSI_NULLS ON
GO
/*
=======================================================================================
'localizado..........: Itec - Manutencao durante o dia
'Função..............: 
'Objetivo............: Geracao arvamore mercadologica novos produtos
'Tabelas.............: EST_PROD_EST_ARV_MERCADOLOGICA | EST_PROD_CPL_MEDIAF | EST_PROD_CPL_MEDIAP
'Dt Modificação......: 09/12/2020
'Modificação.........: Foi adicionado o CD_EMP no where para remover SCAN no plano de execução 
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 

*/
SET QUOTED_IDENTIFIER ON
GO
GO
CREATE PROCEDURE P_EST_PROD_EST_ARV_MERCADOLOGICA 
AS

-- Tag #A001
INSERT INTO   EST_PROD_EST_ARV_MERCADOLOGICA 
	(CD_EMP, CD_PROD, CD_ARV_MERC_CATEG, CD_ARV_MERC_SEG, CD_ARV_MERC_PAPEL, 
		CD_ARV_MERC_MIX, CD_ARV_MERC_CONSUMO, CD_ARV_MERC_LINHA, CD_ARV_MERC_MTZ_BCG, 
		CD_MC, CD_ARV_MERC_FAMILIA, CD_USU, DT_CAD, DT_ULT_ALT, CD_ARV_MERC_EQUI, 
		CD_APRES, CD_GRP_EXPO, CD_ARV_MERC_CLASSIFICACAO)
SELECT     
	P.CD_EMP, 
	P.CD_PROD, 
	0 CD_ARV_MERC_CATEG, 
	0 CD_ARV_MERC_SEG, 
	0 CD_ARV_MERC_PAPEL, 
	0 CD_ARV_MERC_MIX,
	0 CD_ARV_MERC_CONSUMO, 
	0 CD_ARV_MERC_LINHA, 
	0 CD_ARV_MERC_MTZ_BCG, 
	0 CD_MC,  
	0 CD_ARV_MERC_FAMILIA, 
	1 CD_USU, 
	GETDATE() DT_CAD, 
	NULL DT_ULT_ALT, 
	0 CD_ARV_MERC_EQUI, 
	0 CD_APRES, 
	0 CD_GRP_EXPO, 
	0 CD_ARV_MERC_CLASSIFICACAO

FROM         
	 EST_PROD P
	 LEFT OUTER JOIN EST_PROD_EST_ARV_MERCADOLOGICA A ON 
	 P.CD_EMP = A.CD_EMP AND 
	 P.CD_PROD = A.CD_PROD
WHERE P.CD_EMP = 1 
  AND A.CD_PROD IS NULL;
	
--Tag #A001	
	--Inserindo automaticamente a media F somente jogando a curva padrao 
INSERT INTO EST_PROD_CPL_MEDIAF 
            (CD_EMP, CD_FILIAL, 
             CD_PROD,CD_SIGLA, QTDE_MEDIAF, 
             QTDE_FINANCIADO,  QTDE_FACEAMENTO, 
             QTDE_LIMITADOR, 
             VALID_QTDE_FACEAMENTO, 
             QT_VD_ATUAL, 
             QT_VD_MES1, 
             QT_VD_MES2, 
             QT_VD_MES3, 
             LIMITP, 
             LIMITV, 
             CD_USU, 
             DT_CAD, 
             DT_ULT_ALT, 
             SAZ, 
             DT_NASC, 
             MEDIAF_TRANSF) 
SELECT C.CD_EMP, 
       C.CD_FILIAL, 
       C.CD_PROD, 
       4, 
       0                                 AS QTDE_MEDIAF, 
       0                                 AS QTDE_FINANCIADO, 
       0                                 AS QTDE_FACEAMENTO, 
       0                                 AS QTDE_LIMITADOR, 
       NULL                              AS VALID_QTDE_FACEAMENTO, 
       0                                 AS QT_VD_ATUAL, 
       0                                 AS QT_VD_MES1, 
       0                                 AS QT_VD_MES2, 
       0                                 AS QT_VD_MES3, 
       0                                 AS LIMITP, 
       0                                 AS LIMITV, 
       1                                 AS CD_USU, 
       CONVERT(CHAR(10), Getdate(), 112) AS DT_CAD, 
       NULL                              AS DT_ULT_ALT, 
       0                                 AS SAZ, 
       NULL                              AS DT_NASC, 
       0 
FROM   EST_PROD_CPL C 
       LEFT OUTER JOIN EST_PROD_CPL_MEDIAF M 
         ON C.CD_EMP = M.CD_EMP 
            AND C.CD_FILIAL = M.CD_FILIAL 
            AND C.CD_PROD = M.CD_PROD 
WHERE C.CD_EMP= 1
  AND M.CD_PROD IS NULL ;



--Inserindo automaticamente a media prevista de vendas zerada 
INSERT INTO EST_PROD_CPL_MEDIAP 
            (CD_EMP, 
             CD_FILIAL, 
             CD_PROD, 
             QTDE_MEDIAP, 
             CD_USU, 
             DT_CAD, 
             DT_ULT_ALT, 
             FALTA_CRONICA) 
SELECT C.CD_EMP, 
       C.CD_FILIAL, 
       C.CD_PROD, 
       0, 
       1, 
       CONVERT(CHAR(10), Getdate(), 112) AS DT_CAD, 
       NULL, 
       0 
FROM   EST_PROD_CPL C 
       LEFT OUTER JOIN EST_PROD_CPL_MEDIAP M 
         ON C.CD_EMP = M.CD_EMP 
            AND C.CD_FILIAL = M.CD_FILIAL 
            AND C.CD_PROD = M.CD_PROD 
WHERE  M.CD_PROD IS NULL  ;
